<?php
namespace wbb\system\user\object\watch;
use wbb\data\thread\Thread;
use wcf\data\object\type\AbstractObjectTypeProcessor;
use wcf\system\exception\IllegalLinkException;
use wcf\system\user\object\watch\IUserObjectWatch;
use wcf\system\user\storage\UserStorageHandler;

/**
 * Implementation of IUserObjectWatch for watched threads.
 * 
 * @author	Marcel Werk
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\User\Object\Watch
 */
class ThreadUserObjectWatch extends AbstractObjectTypeProcessor implements IUserObjectWatch {
	/**
	 * @inheritDoc
	 */
	public function validateObjectID($objectID) {
		// get thread
		$thread = new Thread($objectID);
		if (!$thread->threadID) throw new IllegalLinkException();
		
		// check permission
		$thread->getBoard()->checkPermission();
	}
	
	/**
	 * @inheritDoc
	 */
	public function resetUserStorage(array $userIDs) {
		UserStorageHandler::getInstance()->reset($userIDs, 'wbbUnreadWatchedThreads');
		UserStorageHandler::getInstance()->reset($userIDs, 'wbbWatchedThreads');
	}
}
