<?php
namespace wbb\system\user\object\watch;
use wbb\data\board\BoardCache;
use wcf\data\object\type\AbstractObjectTypeProcessor;
use wcf\system\exception\IllegalLinkException;
use wcf\system\exception\PermissionDeniedException;
use wcf\system\user\object\watch\IUserObjectWatch;
use wcf\system\user\storage\UserStorageHandler;

/**
 * User object watch implementation for watched boards.
 * 
 * @author	Matthias Schmidt
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\User\Object\Watch
 * @since	5.0
 */
class BoardUserObjectWatch extends AbstractObjectTypeProcessor implements IUserObjectWatch {
	/**
	 * @inheritDoc
	 */
	public function resetUserStorage(array $userIDs) {
		UserStorageHandler::getInstance()->reset($userIDs, 'wbbUnreadWatchedBoards');
		UserStorageHandler::getInstance()->reset($userIDs, 'wbbWatchedBoards');
	}
	
	/**
	 * @inheritDoc
	 */
	public function validateObjectID($objectID) {
		$board = BoardCache::getInstance()->getBoard($objectID);
		if ($board === null) {
			throw new IllegalLinkException();
		}
		
		if (!$board->canEnter() || $board->isPrivate) {
			throw new PermissionDeniedException();
		}
	}
}
