<?php
namespace wbb\system\user\notification\object\type;
use wbb\data\post\Post;
use wbb\data\post\PostList;
use wbb\system\user\notification\object\PostUserNotificationObject;
use wcf\system\user\notification\object\type\AbstractUserNotificationObjectType;

/**
 * Represents a forum post as a notification object type.
 * 
 * @author	Marcel Werk
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\User\Notification\Object\Type
 */
class PostUserNotificationObjectType extends AbstractUserNotificationObjectType {
	/**
	 * @inheritDoc
	 */
	protected static $decoratorClassName = PostUserNotificationObject::class;
	
	/**
	 * @inheritDoc
	 */
	protected static $objectClassName = Post::class;
	
	/**
	 * @inheritDoc
	 */
	protected static $objectListClassName = PostList::class;
}
