<?php
namespace wbb\system\user\notification\object;
use wbb\data\thread\Thread;
use wbb\system\cache\runtime\ThreadRuntimeCache;
use wcf\data\modification\log\ModificationLog;
use wcf\data\DatabaseObject;
use wcf\data\DatabaseObjectDecorator;
use wcf\system\user\notification\object\IUserNotificationObject;

/**
 * Represents a modification log thread as a notification object.
 *
 * @author	Joshua Ruesweg
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\User\Notification\Object
 * @since	5.1
 * 
 * @method	ModificationLog		getDecoratedObject()
 * @mixin	ModificationLog
 */
class ThreadModerationUserNotificationObject extends DatabaseObjectDecorator implements IUserNotificationObject {
	/**
	 * @inheritDoc
	 */
	protected static $baseClass = ModificationLog::class;
	
	/**
	 * @inheritDoc
	 */
	public function __construct(DatabaseObject $object) {
		parent::__construct($object);
		
		ThreadRuntimeCache::getInstance()->cacheObjectID($this->getDecoratedObject()->objectID);
	}
	
	/**
	 * @inheritDoc
	 */
	public function getObjectID() {
		return $this->getDecoratedObject()->logID;
	}
	
	/**
	 * @inheritDoc
	 */
	public function getTitle() {
		return $this->getThread()->getTitle();
	}
	
	/**
	 * @inheritDoc
	 */
	public function getURL() {
		if (!$this->getThread()->canRead()) {
			if ($this->getThread()->getBoard()->canEnter()) {
				return $this->getThread()->getBoard()->getLink();
			}
			else {
				return null;
			}
		}
		
		return $this->getThread()->getLink();
	}
	
	/**
	 * @inheritDoc
	 */
	public function getAuthorID() {
		if (WBB_THREAD_MODERATION_NOTIFICATION_SHOW_MODERATOR) {
			return $this->getDecoratedObject()->userID;
		}
		
		return 0;
	}
	
	/**
	 * Returns the thread object.
	 *
	 * @return Thread
	 */
	public function getThread() {
		return ThreadRuntimeCache::getInstance()->getObject($this->getDecoratedObject()->objectID);
	}
}
