<?php
namespace wbb\system\user\notification\event;
use wbb\system\user\notification\object\ThreadUserNotificationObject;
use wcf\data\user\UserProfile;
use wcf\system\user\notification\event\TTestableUserNotificationEvent;

/**
 * Provides methods to test thread-related user notficiation events.
 * 
 * @author	Matthias Schmidt
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Blog\System\User\Notification\Event
 * @since	3.1
 */
trait TTestableThreadUserNotificationEvent {
	use TTestablePostRelatedUserNotificationEvent;
	use TTestableUserNotificationEvent;
	
	/**
	 * @inheritDoc
	 */
	public static function canBeTriggeredByGuests() {
		return true;
	}
	
	/**
	 * @inheritDoc
	 */
	public static function getTestObjects(UserProfile $recipient, UserProfile $author) {
		return [new ThreadUserNotificationObject(self::createTestThread($author))];
	}
}
