<?php
namespace wbb\system\user\notification\event;
use wbb\system\cache\runtime\ThreadRuntimeCache;
use wbb\system\user\notification\object\PostUserNotificationObject;
use wcf\system\email\Email;
use wcf\system\user\notification\event\AbstractSharedUserNotificationEvent;
use wcf\system\user\notification\event\ITestableUserNotificationEvent;
use wcf\system\user\object\watch\UserObjectWatchHandler;
use wcf\system\user\storage\UserStorageHandler;
use wcf\system\WCF;

/**
 * Notification event for quoted posts.
 * 
 * @author	Marcel Werk
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\User\Notification\Event
 * 
 * @method	PostUserNotificationObject	getUserNotificationObject()
 */
class QuoteUserNotificationEvent extends AbstractSharedUserNotificationEvent implements ITestableUserNotificationEvent {
	use TTestablePostUserNotificationEvent;
	
	/**
	 * @inheritDoc
	 */
	protected function prepare() {
		ThreadRuntimeCache::getInstance()->cacheObjectID($this->getUserNotificationObject()->threadID);
	}
	
	/**
	 * @inheritDoc
	 */
	public function getTitle() {
		return $this->getLanguage()->getDynamicVariable('wbb.post.quote.notification.title');
	}
	
	/**
	 * @inheritDoc
	 */
	public function getMessage() {
		$this->getUserNotificationObject()->setThread(ThreadRuntimeCache::getInstance()->getObject($this->getUserNotificationObject()->threadID));
		
		return $this->getLanguage()->getDynamicVariable('wbb.post.quote.notification.message', [
			'userNotificationObject' => $this->getUserNotificationObject(),
			'author' => $this->author
		]);
	}
	
	/** @noinspection PhpMissingParentCallCommonInspection */
	/**
	 * @inheritDoc
	 */
	public function getEmailMessage($notificationType = 'instant') {
		$this->getUserNotificationObject()->setThread(ThreadRuntimeCache::getInstance()->getObject($this->getUserNotificationObject()->threadID));
		
		$messageID = '<com.woltlab.wbb.post/'.$this->getUserNotificationObject()->postID.'@'.Email::getHost().'>';
		
		return [
			'template' => 'email_notification_quote',
			'application' => 'wbb',
			'in-reply-to' => [$messageID],
			'references' => [
				'<com.woltlab.wbb.thread/'.$this->getUserNotificationObject()->getThread()->threadID.'@'.Email::getHost().'>',
				$messageID
			]
		];
	}
	
	/** @noinspection PhpMissingParentCallCommonInspection */
	/**
	 * @inheritDoc
	 * @since	5.0
	 */
	public function getEmailTitle() {
		$this->getUserNotificationObject()->setThread(ThreadRuntimeCache::getInstance()->getObject($this->getUserNotificationObject()->threadID));
		
		return $this->getLanguage()->getDynamicVariable('wbb.post.quote.notification.mail.title', [
			'userNotificationObject' => $this->getUserNotificationObject()
		]);
	}
	
	/**
	 * @inheritDoc
	 */
	public function getLink() {
		$this->getUserNotificationObject()->setThread(ThreadRuntimeCache::getInstance()->getObject($this->getUserNotificationObject()->threadID));
		
		return $this->getUserNotificationObject()->getLink();
	}
	
	/** @noinspection PhpMissingParentCallCommonInspection */
	/**
	 * @inheritDoc
	 */
	public function checkAccess() {
		$this->getUserNotificationObject()->setThread(ThreadRuntimeCache::getInstance()->getObject($this->getUserNotificationObject()->threadID));
		
		$returnValue = $this->getUserNotificationObject()->canRead();
		if (!$this->getUserNotificationObject()->getThread()->canRead()) {
			// remove subscription
			UserObjectWatchHandler::getInstance()->deleteObjects('com.woltlab.wbb.thread', [$this->getUserNotificationObject()->threadID], [WCF::getUser()->userID]);
			
			// reset user storage
			UserStorageHandler::getInstance()->reset([WCF::getUser()->userID], 'wbbUnreadWatchedThreads');
			
			$returnValue = false;
		}
		
		return $returnValue;
	}
}
