<?php
namespace wbb\system\user\activity\event;
use wbb\data\post\SimplifiedViewablePostList;
use wbb\data\thread\ViewableThreadList;
use wcf\system\user\activity\event\IUserActivityEvent;
use wcf\system\SingletonFactory;
use wcf\system\WCF;

/**
 * User activity event implementation for threads.
 * 
 * @author	Alexander Ebert
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\User\Activity\Event
 */
class ThreadUserActivityEvent extends SingletonFactory implements IUserActivityEvent {
	/**
	 * @inheritDoc
	 */
	public function prepare(array $events) {
		$objectIDs = [];
		foreach ($events as $event) {
			$objectIDs[] = $event->objectID;
		}
		
		// fetch threads
		$threadList = new ViewableThreadList();
		$threadList->setObjectIDs($objectIDs);
		$threadList->readObjects();
		$threads = $threadList->getObjects();
		
		// fetch first posts
		$postIDs = $posts = [];
		foreach ($threads as $thread) {
			$postIDs[] = $thread->firstPostID;
		}
		if (count($postIDs)) {
			$postList = new SimplifiedViewablePostList();
			$postList->setObjectIDs($postIDs);
			$postList->readObjects();
			$posts = $postList->getObjects();
		}
		
		// set message
		foreach ($events as $event) {
			if (isset($threads[$event->objectID])) {
				$thread = $threads[$event->objectID];
				
				// validate permissions
				if (!$thread->canRead()) {
					continue;
				}
				// check ignored boards
				if (WCF::getUser()->userID && $thread->getBoard()->isIgnored()) {
					continue;
				}
				$event->setIsAccessible();
				
				// short output
				$text = WCF::getLanguage()->getDynamicVariable('wcf.user.profile.recentActivity.thread', ['thread' => $thread]);
				$event->setTitle($text);
				
				if (isset($posts[$thread->firstPostID])) {
					$event->setDescription($posts[$thread->firstPostID]->getExcerpt());
				}
			}
			else {
				$event->setIsOrphaned();
			}
		}
	}
}
