<?php
namespace wbb\system\thread\editor;
use wcf\system\language\LanguageFactory;
use wcf\system\tagging\TagEngine;
use wcf\system\WCF;
use wcf\util\ArrayUtil;

/**
 * Provides an editor for thread tags.
 * 
 * @author	Alexander Ebert
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\Thread\Editor
 */
class TagThreadEditor extends AbstractThreadEditor {
	/**
	 * list of label ids
	 * @var	integer[]
	 */
	public $labelIDs = [];
	
	/**
	 * @inheritDoc
	 */
	public function beginEdit() {
		if (!MODULE_TAGGING || !WBB_THREAD_ENABLE_TAGS || !WCF::getSession()->getPermission('user.tag.canViewTag') || !$this->thread->getBoard()->getPermission('canSetTags')) {
			return '';
		}
		
		$tags = TagEngine::getInstance()->getObjectTags('com.woltlab.wbb.thread', $this->thread->threadID, [$this->thread->languageID]);
		
		WCF::getTPL()->assign([
			'tags' => $tags,
			'thread' => $this->thread
		]);
		
		return WCF::getTPL()->fetch('threadEditorTag', 'wbb');
	}
	
	/**
	 * @inheritDoc
	 */
	public function validate(array &$data) {
		if (!MODULE_TAGGING || !WBB_THREAD_ENABLE_TAGS || !WCF::getSession()->getPermission('user.tag.canViewTag') || !$this->thread->getBoard()->getPermission('canSetTags') || empty($data)) {
			return;
		}
		
		if (isset($data[0]) && $data[0] == '__wcf_noTags') {
			$data = [];
		}
		else {
			$data = ArrayUtil::trim($data);
		}
	}
	
	/**
	 * @inheritDoc
	 */
	public function saveEdit(array $data) {
		if (!MODULE_TAGGING || !WBB_THREAD_ENABLE_TAGS || !WCF::getSession()->getPermission('user.tag.canViewTag') || !$this->thread->getBoard()->getPermission('canSetTags')) {
			return [];
		}
		
		// discard current tags
		TagEngine::getInstance()->deleteObjects('com.woltlab.wbb.thread', [$this->thread->threadID]);
		
		if (!empty($data)) {
			// set language id (cannot be zero)
			$languageID = $this->thread->languageID ?: LanguageFactory::getInstance()->getDefaultLanguageID();
			TagEngine::getInstance()->addObjectTags('com.woltlab.wbb.thread', $this->thread->threadID, $data, $languageID);
		}
		
		return [];
	}
}
