<?php
namespace wbb\system\stat;
use wcf\system\stat\AbstractStatDailyHandler;

/**
 * Stat handler implementation for posts.
 * 
 * @author	Marcel Werk
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\Stat
 */
class PostStatDailyHandler extends AbstractStatDailyHandler {
	/**
	 * @inheritDoc
	 */
	public function getData($date) {
		return [
			'counter' => $this->getCounter($date, 'wbb'.WCF_N.'_post', 'time'),
			'total' => $this->getTotal($date, 'wbb'.WCF_N.'_post', 'time')
		];
	}
}
