<?php
namespace wbb\system\sitemap\object;
use wbb\data\thread\Thread;
use wcf\data\DatabaseObject;
use wcf\data\page\PageCache;
use wcf\system\sitemap\object\AbstractSitemapObjectObjectType;

/**
 * Threads sitemap implementation.
 *
 * @author	Joshua Ruesweg
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\Sitemap\Object
 */
class ThreadSitemapObject extends AbstractSitemapObjectObjectType {
	/**
	 * @inheritDoc
	 */
	public function getObjectClass() {
		return Thread::class;
	}
	
	/**
	 * @inheritDoc
	 */
	public function getLastModifiedColumn() {
		return 'lastPostTime';
	}
	
	/**
	 * @inheritDoc
	 */
	public function canView(DatabaseObject $object) {
		/** @var Thread $object */
		return $object->canRead() && !$object->movedThreadID;
	}
	
	/**
	 * @inheritDoc
	 */
	public function isAvailableType() {
		return PageCache::getInstance()->getPageByIdentifier('com.woltlab.wbb.Thread')->allowSpidersToIndex;
	}
}
