<?php
namespace wbb\system\sitemap\object;
use wbb\data\board\Board;
use wbb\data\board\BoardCache;
use wcf\data\DatabaseObject;
use wcf\data\page\PageCache;
use wcf\system\sitemap\object\AbstractSitemapObjectObjectType;

/**
 * Board sitemap implementation.
 *
 * @author	Joshua Ruesweg
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\Sitemap\Object
 */
class BoardSitemapObject extends AbstractSitemapObjectObjectType {
	/**
	 * @inheritDoc
	 */
	public function getObjectClass() {
		return Board::class;
	}
	
	/**
	 * @inheritDoc
	 */
	public function canView(DatabaseObject $object) {
		/** @var Board $object */
		if (!$object->canEnter()) {
			return false;
		}
		
		if ($object->isBoard()) {
			if ($object->threads) {
				return true;
			}
			
			$childBoardIDs = BoardCache::getInstance()->getChildIDs($object->getObjectID());
			
			foreach ($childBoardIDs as $childBoardID) {
				$childBoard = BoardCache::getInstance()->getBoard($childBoardID); 
				
				if ($childBoard->getPermission('canViewBoard') && !$childBoard->isPrivate) {
					return true;
				}
			}
			
			return false;
		}
		else if ($object->isExternalLink()) {
			return false;
		}
		
		return true;
	}
	
	/**
	 * @inheritDoc
	 */
	public function isAvailableType() {
		return PageCache::getInstance()->getPageByIdentifier('com.woltlab.wbb.Board')->allowSpidersToIndex;
	}
}
