<?php
namespace wbb\system\post;
use wbb\system\cache\runtime\PostRuntimeCache;
use wbb\system\cache\runtime\ThreadRuntimeCache;
use wcf\system\SingletonFactory;

/**
 * Caches post and thread objects for post-related user notifications.
 * 
 * @author	Matthias Schmidt
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\Post
 * @deprecated	5.0
 */
class PostDataHandler extends SingletonFactory {
	/**
	 * @inheritDoc
	 */
	public function cachePostID($postID) {
		PostRuntimeCache::getInstance()->cacheObjectID($postID);
	}
	
	/**
	 * @inheritDoc
	 */
	public function cacheThreadID($threadID) {
		ThreadRuntimeCache::getInstance()->cacheObjectID($threadID);
	}
	
	/**
	 * @inheritDoc
	 */
	public function getPost($postID) {
		return PostRuntimeCache::getInstance()->getObject($postID);
	}
	
	/**
	 * @inheritDoc
	 */
	public function getThread($threadID) {
		return ThreadRuntimeCache::getInstance()->getObject($threadID);
	}
}
