<?php
namespace wbb\system\poll;
use wbb\system\cache\runtime\PostRuntimeCache;
use wcf\data\poll\Poll;
use wcf\system\poll\AbstractPollHandler;
use wcf\system\WCF;

/**
 * An implementation of IPollHandler for forum posts.
 * 
 * @author	Alexander Ebert
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\Poll
 */
class PostPollHandler extends AbstractPollHandler {
	/** @noinspection PhpMissingParentCallCommonInspection */
	/**
	 * @inheritDoc
	 */
	public function canStartPublicPoll() {
		return WCF::getSession()->getPermission('user.board.canStartPublicPoll') ? true : false;
	}
	
	/** @noinspection PhpMissingParentCallCommonInspection */
	/**
	 * @inheritDoc
	 */
	public function canVote() {
		return WCF::getSession()->getPermission('user.board.canVotePoll') ? true : false;
	}
	
	/**
	 * @inheritDoc
	 */
	public function getRelatedObject(Poll $poll) {
		$post = PostRuntimeCache::getInstance()->getObject($poll->objectID);
		if ($post && $post->pollID == $poll->pollID) {
			return $post;
		}
		
		return null;
	}
}
