<?php
namespace wbb\system\page\handler;
use wbb\data\board\Board;
use wcf\system\database\util\PreparedStatementConditionBuilder;
use wcf\system\page\handler\AbstractMenuPageHandler;
use wcf\system\user\object\watch\UserObjectWatchHandler;
use wcf\system\user\storage\UserStorageHandler;
use wcf\system\visitTracker\VisitTracker;
use wcf\system\WCF;

/**
 * Page handler for watched thread list.
 *
 * @author	Marcel Werk
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\Page\Handler
 * @since	5.0
 */
class WatchedThreadListPageHandler extends AbstractMenuPageHandler {
	/**
	 * number of unread watched threads.
	 * @var	integer
	 */
	protected $notifications;
	
	/** @noinspection PhpMissingParentCallCommonInspection */
	/**
	 * @inheritDoc
	 */
	public function isVisible($objectID = null) {
		$count = 0;
		if (WCF::getUser()->userID) {
			$data = UserStorageHandler::getInstance()->getField('wbbWatchedThreads');
			
			// cache does not exist or is outdated
			if ($data === null) {
				$boardIDs = Board::filterBoardIDs(Board::getAccessibleBoardIDs());
				$privateBoardIDs = Board::filterBoardIDs(Board::getPrivateBoardIDs());
				if (!empty($boardIDs) || !empty($privateBoardIDs)) {
					$objectTypeID = UserObjectWatchHandler::getInstance()->getObjectTypeID('com.woltlab.wbb.thread');
					
					$conditionBuilder = new PreparedStatementConditionBuilder();
					
					if (empty($privateBoardIDs)) {
						$conditionBuilder->add("thread.boardID IN (?)", [$boardIDs]);
					}
					else if (empty($boardIDs)) {
						$conditionBuilder->add("(thread.boardID IN (?) AND thread.userID = ?)", [$privateBoardIDs, WCF::getUser()->userID]);
					}
					else {
						$conditionBuilder->add("(thread.boardID IN (?) OR (thread.boardID IN (?) AND thread.userID = ?))", [$boardIDs, $privateBoardIDs, WCF::getUser()->userID]);
					}
					
					$conditionBuilder->add('user_object_watch.objectTypeID = ?', [$objectTypeID]);
					$conditionBuilder->add('user_object_watch.userID = ?', [WCF::getUser()->userID]);
					$conditionBuilder->add('thread.isDeleted = 0 AND thread.isDisabled = 0');
					
					$sql = "SELECT		COUNT(*) AS count
						FROM		wcf".WCF_N."_user_object_watch user_object_watch
						LEFT JOIN	wbb".WCF_N."_thread thread
						ON		(thread.threadID = user_object_watch.objectID)
						".$conditionBuilder;
					$statement = WCF::getDB()->prepareStatement($sql);
					$statement->execute($conditionBuilder->getParameters());
					$count = $statement->fetchSingleColumn();
				}
				
				// update storage data
				UserStorageHandler::getInstance()->update(WCF::getUser()->userID, 'wbbWatchedThreads', $count);
			}
			else {
				$count = $data;
			}
		}
		
		return ($count != 0);
	}
	
	/** @noinspection PhpMissingParentCallCommonInspection */
	/**
	 * @inheritDoc
	 */
	public function getOutstandingItemCount($objectID = null) {
		if ($this->notifications === null) {
			$this->notifications = 0;
			
			if (WCF::getUser()->userID) {
				$data = UserStorageHandler::getInstance()->getField('wbbUnreadWatchedThreads');
				
				// cache does not exist or is outdated
				if ($data === null) {
					$boardIDs = Board::filterBoardIDs(Board::getAccessibleBoardIDs());
					$privateBoardIDs = Board::filterBoardIDs(Board::getPrivateBoardIDs());
					if (!empty($boardIDs) || !empty($privateBoardIDs)) {
						$objectTypeID = UserObjectWatchHandler::getInstance()->getObjectTypeID('com.woltlab.wbb.thread');
						
						$conditionBuilder = new PreparedStatementConditionBuilder();
						
						if (empty($privateBoardIDs)) {
							$conditionBuilder->add("thread.boardID IN (?)", [$boardIDs]);
						}
						else if (empty($boardIDs)) {
							$conditionBuilder->add("(thread.boardID IN (?) AND thread.userID = ?)", [$privateBoardIDs, WCF::getUser()->userID]);
						}
						else {
							$conditionBuilder->add("(thread.boardID IN (?) OR (thread.boardID IN (?) AND thread.userID = ?))", [$boardIDs, $privateBoardIDs, WCF::getUser()->userID]);
						}
						
						$conditionBuilder->add('user_object_watch.objectTypeID = ?', [$objectTypeID]);
						$conditionBuilder->add('user_object_watch.userID = ?', [WCF::getUser()->userID]);
						$conditionBuilder->add('thread.lastPostTime > ?', [VisitTracker::getInstance()->getVisitTime('com.woltlab.wbb.thread')]);
						$conditionBuilder->add('thread.isDeleted = 0 AND thread.isDisabled = 0');
						$conditionBuilder->add('(thread.lastPostTime > tracked_thread_visit.visitTime OR tracked_thread_visit.visitTime IS NULL)');
						$conditionBuilder->add('(thread.lastPostTime > tracked_board_visit.visitTime OR tracked_board_visit.visitTime IS NULL)');
						
						$sql = "SELECT		COUNT(*) AS count
							FROM		wcf".WCF_N."_user_object_watch user_object_watch
							LEFT JOIN	wbb".WCF_N."_thread thread
							ON		(thread.threadID = user_object_watch.objectID)
							LEFT JOIN	wcf".WCF_N."_tracked_visit tracked_thread_visit
							ON		(tracked_thread_visit.objectTypeID = ".VisitTracker::getInstance()->getObjectTypeID('com.woltlab.wbb.thread')." AND tracked_thread_visit.objectID = thread.threadID AND tracked_thread_visit.userID = ".WCF::getUser()->userID.")
							LEFT JOIN	wcf".WCF_N."_tracked_visit tracked_board_visit
							ON		(tracked_board_visit.objectTypeID = ".VisitTracker::getInstance()->getObjectTypeID('com.woltlab.wbb.board')." AND tracked_board_visit.objectID = thread.boardID AND tracked_board_visit.userID = ".WCF::getUser()->userID.")
							".$conditionBuilder;
						$statement = WCF::getDB()->prepareStatement($sql);
						$statement->execute($conditionBuilder->getParameters());
						$row = $statement->fetchArray();
						$this->notifications = $row['count'];
					}
					
					// update storage data
					UserStorageHandler::getInstance()->update(WCF::getUser()->userID, 'wbbUnreadWatchedThreads', $this->notifications);
				}
				else {
					$this->notifications = $data;
				}
			}
		}
		
		return $this->notifications;
	}
}
