<?php
namespace wbb\system\page\handler;
use wbb\data\board\Board;
use wbb\data\board\BoardCache;
use wcf\system\database\util\PreparedStatementConditionBuilder;
use wcf\system\page\handler\AbstractMenuPageHandler;
use wcf\system\user\object\watch\UserObjectWatchHandler;
use wcf\system\user\storage\UserStorageHandler;
use wcf\system\WCF;

/**
 * Page handler for watched board list.
 *
 * @author	Marcel Werk
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\Page\Handler
 * @since	5.0
 */
class WatchedBoardListPageHandler extends AbstractMenuPageHandler {
	/**
	 * number of unread watched threads.
	 * @var	integer
	 */
	protected $notifications;
	
	/** @noinspection PhpMissingParentCallCommonInspection */
	/**
	 * @inheritDoc
	 */
	public function isVisible($objectID = null) {
		$count = 0;
		if (WCF::getUser()->userID) {
			$data = UserStorageHandler::getInstance()->getField('wbbWatchedBoards');
			
			// cache does not exist or is outdated
			if ($data === null) {
				// private boards are excluded
				$boardIDs = Board::getAccessibleBoardIDs();
				if (!empty($boardIDs)) {
					$conditionBuilder = new PreparedStatementConditionBuilder();
					$conditionBuilder->add('objectTypeID = ?', [UserObjectWatchHandler::getInstance()->getObjectTypeID('com.woltlab.wbb.board')]);
					$conditionBuilder->add('objectID IN (?)', [$boardIDs]);
					$conditionBuilder->add('userID = ?', [WCF::getUser()->userID]);
					
					$sql = "SELECT	COUNT(*) AS count
						FROM	wcf".WCF_N."_user_object_watch
						".$conditionBuilder;
					$statement = WCF::getDB()->prepareStatement($sql);
					$statement->execute($conditionBuilder->getParameters());
					$count = $statement->fetchSingleColumn();
				}
				
				// update storage data
				UserStorageHandler::getInstance()->update(WCF::getUser()->userID, 'wbbWatchedBoards', $count);
			}
			else {
				$count = $data;
			}
		}
		
		return ($count != 0);
	}
	
	/** @noinspection PhpMissingParentCallCommonInspection */
	/**
	 * @inheritDoc
	 */
	public function getOutstandingItemCount($objectID = null) {
		if ($this->notifications === null) {
			$this->notifications = 0;
			
			if (WCF::getUser()->userID) {
				$data = UserStorageHandler::getInstance()->getField('wbbUnreadWatchedBoards');
				
				// cache does not exist or is outdated
				if ($data === null) {
					// private boards are excluded
					$boardIDs = Board::getAccessibleBoardIDs();
					if (!empty($boardIDs)) {
						$conditionBuilder = new PreparedStatementConditionBuilder();
						$conditionBuilder->add('objectTypeID = ?', [UserObjectWatchHandler::getInstance()->getObjectTypeID('com.woltlab.wbb.board')]);
						$conditionBuilder->add('objectID IN (?)', [$boardIDs]);
						$conditionBuilder->add('userID = ?', [WCF::getUser()->userID]);
						
						$sql = "SELECT	objectID
							FROM	wcf".WCF_N."_user_object_watch
							".$conditionBuilder;
						$statement = WCF::getDB()->prepareStatement($sql);
						$statement->execute($conditionBuilder->getParameters());
						
						while ($boardID = $statement->fetchColumn()) {
							$this->notifications += BoardCache::getInstance()->getUnreadThreads($boardID);
						}
					}
					
					// update storage data
					UserStorageHandler::getInstance()->update(WCF::getUser()->userID, 'wbbUnreadWatchedBoards', $this->notifications);
				}
				else {
					$this->notifications = $data;
				}
			}
		}
		
		return $this->notifications;
	}
}
