<?php
namespace wbb\system\page\handler;
use wbb\data\board\BoardCache;
use wbb\system\cache\runtime\ThreadRuntimeCache;
use wcf\system\page\handler\AbstractMenuPageHandler;
use wcf\system\page\handler\IOnlineLocationPageHandler;

/**
 * Page handler for thread log page.
 *
 * @author	Marcel Werk
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\Page\Handler
 * @since	5.0
 */
class ThreadLogPageHandler extends AbstractMenuPageHandler implements IOnlineLocationPageHandler {
	use TThreadOnlineLocationPageHandler;
	
	/** @noinspection PhpMissingParentCallCommonInspection */
	/**
	 * @inheritDoc
	 */
	public function isVisible($objectID = null) {
		return BoardCache::getInstance()->getBoard(ThreadRuntimeCache::getInstance()->getObject($objectID)->boardID)->canEditThreads();
	}
}
