<?php
namespace wbb\system\page\handler;
use wbb\system\cache\runtime\ThreadRuntimeCache;
use wcf\data\page\Page;
use wcf\data\user\online\UserOnline;
use wcf\system\page\handler\TOnlineLocationPageHandler;
use wcf\system\WCF;

/**
 * Implementation of the online location-related page handler methods for threads.
 * 
 * @author	Matthias Schmidt
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\Page\Handler
 * @since	5.0
 */
trait TThreadOnlineLocationPageHandler {
	use TOnlineLocationPageHandler;
	
	/**
	 * @inheritDoc
	 */
	public function getOnlineLocation(Page $page, UserOnline $user) {
		if ($user->pageObjectID === null) {
			return '';
		}
		
		$thread = ThreadRuntimeCache::getInstance()->getObject($user->pageObjectID);
		if ($thread === null || !$thread->canRead()) {
			return '';
		}
		
		return WCF::getLanguage()->getDynamicVariable('wcf.page.onlineLocation.'.$page->identifier, ['thread' => $thread]);
	}
	
	/**
	 * @inheritDoc
	 */
	public function prepareOnlineLocation(/** @noinspection PhpUnusedParameterInspection */Page $page, UserOnline $user) {
		if ($user->pageObjectID !== null) {
			ThreadRuntimeCache::getInstance()->cacheObjectID($user->pageObjectID);
		}
	}
}
