<?php
namespace wbb\system\option;
use wbb\data\board\BoardCache;
use wbb\data\board\BoardNodeList;
use wcf\data\option\Option;
use wcf\system\exception\UserInputException;
use wcf\system\option\AbstractOptionType;
use wcf\system\WCF;
use wcf\util\ArrayUtil;

/**
 * Option type implementation for multi select lists.
 * 
 * @author	Marcel Werk
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\Option
 */
class WBBBoardMultiSelectOptionType extends AbstractOptionType {
	/**
	 * @inheritDoc
	 */
	public function getFormElement(Option $option, $value) {
		// get searchable boards
		$boardNodeList = new BoardNodeList();
		$boardNodeList->readNodeTree();
		
		WCF::getTPL()->assign([
			'boardNodeList' => $boardNodeList->getNodeList(),
			'option' => $option,
			'value' => !is_array($value) ? explode("\n", $value) : $value
		]);
		return WCF::getTPL()->fetch('boardMultiSelectOptionType', 'wbb');
	}
	
	/**
	 * @inheritDoc
	 */
	public function validate(Option $option, $newValue) {
		if (!is_array($newValue)) $newValue = [];
		$newValue = ArrayUtil::toIntegerArray($newValue);
		
		foreach ($newValue as $boardID) {
			if (BoardCache::getInstance()->getBoard($boardID) === null) {
				throw new UserInputException($option->optionName, 'validationFailed');
			}
		}
	}
	
	/** @noinspection PhpMissingParentCallCommonInspection */
	/**
	 * @inheritDoc
	 */
	public function getData(Option $option, $newValue) {
		if (!is_array($newValue)) $newValue = [];
		return implode("\n", ArrayUtil::toIntegerArray($newValue));
	}
}
