<?php
namespace wbb\system\moderation\queue\report;
use wbb\data\post\ViewablePostList;
use wbb\system\moderation\queue\AbstractPostModerationQueueHandler;
use wcf\data\moderation\queue\ViewableModerationQueue;
use wcf\system\moderation\queue\report\IModerationQueueReportHandler;
use wcf\system\WCF;

/**
 * An implementation of IModerationQueueReportHandler for forum posts.
 * 
 * @author	Alexander Ebert
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\Moderation\Queue\Report
 */
class PostModerationQueueReportHandler extends AbstractPostModerationQueueHandler implements IModerationQueueReportHandler {
	/**
	 * @inheritDoc
	 */
	protected $definitionName = 'com.woltlab.wcf.moderation.report';
	
	/**
	 * @inheritDoc
	 */
	protected $objectType = 'com.woltlab.wbb.post';
	
	/**
	 * @inheritDoc
	 */
	public function canReport($objectID) {
		if (!$this->isValid($objectID)) {
			return false;
		}
		
		if (!$this->getPost($objectID)->canRead()) {
			return false;
		}
		
		return true;
	}
	
	/**
	 * @inheritDoc
	 */
	public function getReportedContent(ViewableModerationQueue $queue) {
		$list = new ViewablePostList();
		/** @noinspection PhpUndefinedFieldInspection */
		$list->setObjectIDs([$queue->getAffectedObject()->postID]);
		$list->readObjects();
		$posts = $list->getObjects();
		
		WCF::getTPL()->assign([
			'post' => reset($posts),
			'attachmentList' => $list->getAttachmentList()
		]);
		
		return WCF::getTPL()->fetch('moderationPost', 'wbb');
	}
	
	/**
	 * @inheritDoc
	 */
	public function getReportedObject($objectID) {
		if ($this->isValid($objectID)) {
			return $this->getPost($objectID);
		}
		
		return null;
	}
}
