<?php
namespace wbb\system\moderation;
use wbb\data\post\DeletedPostList;
use wcf\system\moderation\AbstractDeletedContentProvider;

/**
 * Implementation of IDeletedContentProvider for deleted posts.
 * 
 * @author	Marcel Werk
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\Moderation
 */
class DeletedPostProvider extends AbstractDeletedContentProvider {
	/**
	 * @inheritDoc
	 */
	public function getObjectList() {
		$postList = new DeletedPostList();
		$postList->sqlOrderBy = "post.deleteTime DESC, post.postID DESC";
		
		return $postList;
	}
	
	/**
	 * @inheritDoc
	 */
	public function getTemplateName() {
		return 'deletedPostList';
	}
}
