<?php
namespace wbb\system\message\quote;
use wbb\data\post\PostList;
use wbb\data\thread\ThreadList;
use wcf\system\message\quote\AbstractMessageQuoteHandler;
use wcf\system\message\quote\MessageQuoteManager;
use wcf\system\message\quote\QuotedMessage;

/**
 * IMessageQuoteHandler implementation for posts.
 * 
 * @author	Alexander Ebert
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\Message\Quote
 */
class PostMessageQuoteHandler extends AbstractMessageQuoteHandler {
	/**
	 * @inheritDoc
	 */
	protected function getMessages(array $data) {
		// read posts
		$postList = new PostList();
		$postList->setObjectIDs(array_keys($data));
		$postList->readObjects();
		$posts = $postList->getObjects();
		
		// read threads
		$threadIDs = $validPostIDs = [];
		foreach ($posts as $post) {
			$threadIDs[] = $post->threadID;
			$validPostIDs[] = $post->postID;
		}
		
		$quotedMessages = [];
		if (!empty($threadIDs)) {
			$threadList = new ThreadList();
			$threadList->setObjectIDs($threadIDs);
			$threadList->readObjects();
			$threads = $threadList->getObjects();
			
			// assign threads
			foreach ($posts as $post) {
				$post->setThread($threads[$post->threadID]);
			}
			
			// create QuotedMessage objects
			foreach ($posts as $post) {
				$message = new QuotedMessage($post);
				
				foreach (array_keys($data[$post->postID]) as $quoteID) {
					$message->addQuote(
						$quoteID,
						MessageQuoteManager::getInstance()->getQuote($quoteID, false),	// single quote or excerpt
						MessageQuoteManager::getInstance()->getQuote($quoteID, true)	// same as above or full quote
					);
				}
				
				$quotedMessages[] = $message;
			}
		}
		
		// check for orphaned quotes
		if (count($validPostIDs) != count($data)) {
			$orphanedQuoteIDs = [];
			foreach ($data as $postID => $quoteIDs) {
				if (!in_array($postID, $validPostIDs)) {
					foreach (array_keys($quoteIDs) as $quoteID) {
						$orphanedQuoteIDs[] = $quoteID;
					}
				}
			}
			
			MessageQuoteManager::getInstance()->removeOrphanedQuotes($orphanedQuoteIDs);
		}
		
		return $quotedMessages;
	}
}
