<?php
namespace wbb\system\label\object;
use wbb\data\board\BoardCache;
use wcf\system\label\object\AbstractLabelObjectHandler;
use wcf\system\label\LabelHandler;

/**
 * Label handler for threads.
 * 
 * @author	Alexander Ebert
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\Label\Object
 */
class ThreadLabelObjectHandler extends AbstractLabelObjectHandler {
	/**
	 * board id
	 * @var	integer
	 */
	protected $boardID = 0;
	
	/**
	 * @inheritDoc
	 */
	protected $objectType = 'com.woltlab.wbb.thread';
	
	/**
	 * Sets current board id and loads associated label groups.
	 * 
	 * @param	integer		$boardID
	 */
	public function setBoardID($boardID) {
		$this->boardID = $boardID;
		
		// load label groups
		$groupIDs = BoardCache::getInstance()->getLabelGroupIDs($this->boardID);
		$this->labelGroups = empty($groupIDs) ? [] : LabelHandler::getInstance()->getLabelGroups($groupIDs);
	}
}
