<?php
namespace wbb\system\importer;
use wcf\data\object\type\ObjectTypeCache;
use wcf\system\importer\AbstractWatchedObjectImporter;
use wcf\system\importer\ImportHandler;

/**
 * Imports watched threads.
 * 
 * @author	Marcel Werk
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\Importer
 */
class WatchedThreadImporter extends AbstractWatchedObjectImporter {
	/**
	 * Creates a new WatchedThreadImporter object.
	 */
	public function __construct() {
		$objectType = ObjectTypeCache::getInstance()->getObjectTypeByName('com.woltlab.wcf.user.objectWatch', 'com.woltlab.wbb.thread');
		$this->objectTypeID = $objectType->objectTypeID;
	}
	
	/**
	 * @inheritDoc
	 */
	public function import($oldID, array $data, array $additionalData = []) {
		$data['objectID'] = ImportHandler::getInstance()->getNewID('com.woltlab.wbb.thread', $data['objectID']);
		if (!$data['objectID']) return 0;
		
		return parent::import($oldID, $data);
	}
}
