<?php
namespace wbb\system\importer;
use wbb\data\thread\Thread;
use wbb\data\thread\ThreadEditor;
use wcf\data\object\type\ObjectTypeCache;
use wcf\system\importer\AbstractImporter;
use wcf\system\importer\ImportHandler;
use wcf\system\language\LanguageFactory;
use wcf\system\tagging\TagEngine;
use wcf\system\WCF;

/**
 * Imports threads.
 * 
 * @author	Marcel Werk
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\Importer
 */
class ThreadImporter extends AbstractImporter {
	/**
	 * @inheritDoc
	 */
	protected $className = Thread::class;
	
	/**
	 * @inheritDoc
	 */
	public function import($oldID, array $data, array $additionalData = []) {
		$data['boardID'] = ImportHandler::getInstance()->getNewID('com.woltlab.wbb.board', $data['boardID']);
		if (!$data['boardID']) return 0;
		$data['userID'] = ImportHandler::getInstance()->getNewID('com.woltlab.wcf.user', $data['userID']);
		
		// handle moved threads
		if (!empty($data['movedThreadID'])) {
			$data['movedThreadID'] = ImportHandler::getInstance()->getNewID('com.woltlab.wbb.thread', $data['movedThreadID']);
			if (!$data['movedThreadID']) return 0;
		}
		
		// handle language
		if (!empty($additionalData['languageCode'])) {
			if (($language = LanguageFactory::getInstance()->getLanguageByCode($additionalData['languageCode'])) !== null) {
				$data['languageID'] = $language->languageID;
			}
		}
		
		// check old id
		if (ctype_digit((string)$oldID)) {
			$thread = new Thread($oldID);
			if (!$thread->threadID) $data['threadID'] = $oldID;
		}
		
		// save thread
		$thread = ThreadEditor::create($data);
		
		// save assigned boards
		if (!empty($additionalData['assignedBoards'])) {
			$sql = "INSERT INTO	wbb".WCF_N."_thread_announcement
						(boardID, threadID)
				VALUES		(?, ?)";
			$statement = WCF::getDB()->prepareStatement($sql);
			
			foreach ($additionalData['assignedBoards'] as $boardID) {
				$boardID = ImportHandler::getInstance()->getNewID('com.woltlab.wbb.board', $boardID);
				if (!$boardID) continue;
				
				$statement->execute([$boardID, $thread->threadID]);
			}
		}
		
		// save labels
		if (!empty($additionalData['labels'])) {
			$objectType = ObjectTypeCache::getInstance()->getObjectTypeByName('com.woltlab.wcf.label.object', 'com.woltlab.wbb.thread');
			
			$sql = "INSERT INTO	wcf".WCF_N."_label_object
						(labelID, objectTypeID, objectID)
				VALUES		(?, ?, ?)";
			$statement = WCF::getDB()->prepareStatement($sql);
			foreach ($additionalData['labels'] as $labelID) {
				$labelID = ImportHandler::getInstance()->getNewID('com.woltlab.wcf.label', $labelID);
				if (!$labelID) continue;
				
				$statement->execute([$labelID, $objectType->objectTypeID, $thread->threadID]);
			}
		}
		
		// save tags
		if (!empty($additionalData['tags'])) {
			TagEngine::getInstance()->addObjectTags('com.woltlab.wbb.thread', $thread->threadID, $additionalData['tags'], $thread->languageID ?: LanguageFactory::getInstance()->getDefaultLanguageID());
		}
		
		ImportHandler::getInstance()->saveNewID('com.woltlab.wbb.thread', $oldID, $thread->threadID);
		return $thread->threadID;
	}
}
