<?php
namespace wbb\system\importer;
use wbb\data\post\Post;
use wbb\data\post\PostEditor;
use wcf\system\importer\AbstractImporter;
use wcf\system\importer\ImportHandler;

/**
 * Imports posts.
 * 
 * @author	Marcel Werk
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\Importer
 */
class PostImporter extends AbstractImporter {
	/**
	 * @inheritDoc
	 */
	protected $className = Post::class;
	
	/**
	 * @inheritDoc
	 */
	public function import($oldID, array $data, array $additionalData = []) {
		$data['threadID'] = ImportHandler::getInstance()->getNewID('com.woltlab.wbb.thread', $data['threadID']);
		if (!$data['threadID']) return 0;
		$data['userID'] = ImportHandler::getInstance()->getNewID('com.woltlab.wcf.user', $data['userID']);
		if ($data['editorID']) $data['editorID'] = ImportHandler::getInstance()->getNewID('com.woltlab.wcf.user', $data['editorID']);
		
		// check old id
		if (ctype_digit((string)$oldID)) {
			$post = new Post($oldID);
			if (!$post->postID) $data['postID'] = $oldID;
		}
		
		$post = PostEditor::create($data);
		
		ImportHandler::getInstance()->saveNewID('com.woltlab.wbb.post', $oldID, $post->postID);
		
		return $post->postID;
	}
}
