<?php
namespace wbb\system\importer;
use wbb\data\board\Board;
use wbb\data\board\BoardAction;
use wbb\data\board\BoardEditor;
use wcf\system\importer\AbstractImporter;
use wcf\system\importer\ImportHandler;

/**
 * Imports boards.
 * 
 * @author	Alexander Ebert, Marcel Werk
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\Importer
 */
class BoardImporter extends AbstractImporter {
	/**
	 * @inheritDoc
	 */
	protected $className = Board::class;
	
	/**
	 * @inheritDoc
	 */
	public function import($oldID, array $data, array $additionalData = []) {
		if ($data['parentID'] !== null) $data['parentID'] = ImportHandler::getInstance()->getNewID('com.woltlab.wbb.board', $data['parentID']);
		
		// check old id
		if (ctype_digit((string)$oldID)) {
			$board = new Board($oldID);
			if (!$board->boardID) $data['boardID'] = $oldID;
		}
		
		$action = new BoardAction([], 'create', [
			'data' => $data
		]);
		$returnValues = $action->executeAction();
		$board = $returnValues['returnValues'];
		$newID = $board->boardID;
		
		// handle i18n values
		if (!empty($additionalData['i18n'])) {
			$values = [];
			
			foreach (['title', 'description'] as $property) {
				if (isset($additionalData['i18n'][$property])) {
					$values[$property] = $additionalData['i18n'][$property];
				}
			}
			
			if (!empty($values)) {
				$updateData = [];
				if (isset($values['title'])) $updateData['title'] = 'wbb.board.board' . $newID;
				if (isset($values['description'])) $updateData['description'] = 'wbb.board.board' . $newID . '.description';
				
				$items = [];
				foreach ($values as $property => $propertyValues) {
					foreach ($propertyValues as $languageID => $languageItemValue) {
						$items[] = [
							'languageID' => $languageID,
							'languageItem' => 'wbb.board.board' . $newID . ($property === 'description' ? '.description' : ''),
							'languageItemValue' => $languageItemValue
						];
					}
				}
				
				$this->importI18nValues($items, 'wbb.board', 'com.woltlab.wbb');
				
				(new BoardEditor($board))->update($updateData);
			}
		}
		
		ImportHandler::getInstance()->saveNewID('com.woltlab.wbb.board', $oldID, $newID);
		
		return $newID;
	}
}
