<?php
namespace wbb\system\importer;
use wcf\data\object\type\ObjectTypeCache;
use wcf\system\importer\AbstractACLImporter;

/**
 * Imports ACLs.
 * 
 * @author	Marcel Werk
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\Importer
 */
class ACLImporter extends AbstractACLImporter {
	/**
	 * @inheritDoc
	 */
	protected $objectTypeName = 'com.woltlab.wbb.board';
	
	/**
	 * Creates a new ACLImporter object.
	 */
	public function __construct() {
		$objectType = ObjectTypeCache::getInstance()->getObjectTypeByName('com.woltlab.wcf.acl', 'com.woltlab.wbb.board');
		$this->objectTypeID = $objectType->objectTypeID;
		
		parent::__construct();
	}
}
