<?php
namespace wbb\system\event\listener;
use wcf\system\event\listener\IParameterizedEventListener;
use wcf\system\option\OptionHandler;

/**
 * Registers 'wbbPosts' as select option for members list page.
 * 
 * @author	Alexander Ebert
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\Event\Listener
 */
class WBBOptionHandlerListener implements IParameterizedEventListener {
	/**
	 * @inheritDoc
	 */
	public function execute($eventObj, $className, $eventName, array &$parameters) {
		/** @var OptionHandler $eventObj */
		
		$selectOptions = $eventObj->cachedOptions['members_list_default_sort_field']->selectOptions . "\nwbbPosts:wbb.post.posts";
		$eventObj->cachedOptions['members_list_default_sort_field']->modifySelectOptions($selectOptions);
	}
}
