<?php
namespace wbb\system\event\listener;
use wbb\data\board\BoardCache;
use wcf\system\database\util\PreparedStatementConditionBuilder;
use wcf\system\event\listener\IParameterizedEventListener;
use wcf\system\worker\UserRebuildDataWorker;
use wcf\system\WCF;

/**
 * Updates users' post counter.
 * 
 * @author	Marcel Werk
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\Event\Listener
 */
class UserRebuildDataWorkerListener implements IParameterizedEventListener {
	/**
	 * @inheritDoc
	 */
	public function execute($eventObj, $className, $eventName, array &$parameters) {
		/** @var UserRebuildDataWorker $eventObj */
		
		$userIDs = [];
		foreach ($eventObj->getObjectList() as $user) {
			$userIDs[] = $user->userID;
		}
		
		if (!empty($userIDs)) {
			// get boards ids
			$boardIDs = $bestAnswerBoardIDs = [];
			foreach (BoardCache::getInstance()->getBoards() as $board) {
				if ($board->countUserPosts) $boardIDs[] = $board->boardID;
				if ($board->enableBestAnswer) $bestAnswerBoardIDs[] = $board->boardID;
			}
			
			// update post counter
			if (!empty($boardIDs)) {
				$conditionBuilder = new PreparedStatementConditionBuilder();
				$conditionBuilder->add('user_table.userID IN (?)', [$userIDs]);
				$sql = "UPDATE	wcf".WCF_N."_user user_table
					SET	wbbPosts = (
							SELECT	        COUNT(*)
							FROM	        wbb".WCF_N."_post post
							INNER JOIN      wbb".WCF_N."_thread thread
							ON              thread.threadID = post.threadID
							WHERE	        post.userID = user_table.userID
									AND thread.boardID IN (".implode(',', $boardIDs).")
									AND post.isDisabled = 0
						)
					".$conditionBuilder;
				$statement = WCF::getDB()->prepareStatement($sql);
				$statement->execute($conditionBuilder->getParameters());
			}
			
			// update best answer counters
			if (!empty($bestAnswerBoardIDs)) {
				$conditionBuilder = new PreparedStatementConditionBuilder();
				$conditionBuilder->add('user_table.userID IN (?)', [$userIDs]);
				$sql = "UPDATE	wcf".WCF_N."_user user_table
					SET	wbbBestAnswers = (
							SELECT	        COUNT(*)
							FROM	        wbb".WCF_N."_post post
							INNER JOIN      wbb".WCF_N."_thread thread
							ON              thread.threadID = post.threadID
							WHERE	        post.userID = user_table.userID
									AND thread.boardID IN (".implode(',', $bestAnswerBoardIDs).")
									AND thread.bestAnswerPostID = post.postID
									AND post.isDisabled = 0
						)
					".$conditionBuilder;
				$statement = WCF::getDB()->prepareStatement($sql);
				$statement->execute($conditionBuilder->getParameters());
			}
		}
	}
}
