<?php
namespace wbb\system\event\listener;
use wbb\data\board\BoardCache;
use wcf\system\event\listener\IParameterizedEventListener;

/**
 * Injects custom SCSS style rules for custom board icons.
 * 
 * @author	Alexander Ebert
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\Event\Listener
 */
class StyleCompilerListener implements IParameterizedEventListener {
	/**
	 * @inheritDoc
	 */
	public function execute($eventObj, $className, $eventName, array &$parameters) {
		$scss = '';
		
		foreach (BoardCache::getInstance()->getBoards() as $board) {
			if ($board->isBoard()) {
				foreach (['default', 'unread', 'closed'] as $type) {
					$scss .= $board->getStyleRules($type);
				}
			}
			else if ($board->isExternalLink()) {
				$scss .= $board->getStyleRules('external');
			}
		}
		
		$parameters['scss'] .= (!empty($parameters['scss']) ? "\n" : '') . $scss;
	}
}
