<?php
namespace wbb\system\event\listener;
use wcf\system\event\listener\IParameterizedEventListener;
use wcf\system\language\LanguageFactory;
use wcf\system\user\storage\UserStorageHandler;
use wcf\system\WCF;

/**
 * Resets the number of unread threads after submitting the settings form to
 * account for new content languages if multilingualism is enabled.
 * 
 * @author	Matthias Schmidt
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\Event\Listener
 */
class SettingsFormListener implements IParameterizedEventListener {
	/**
	 * @inheritDoc
	 */
	public function execute($eventObj, $className, $eventName, array &$parameters) {
		if (LanguageFactory::getInstance()->multilingualismEnabled()) {
			UserStorageHandler::getInstance()->reset([WCF::getUser()->userID], 'wbbUnreadThreads');
		}
	}
}
