<?php
namespace wbb\system\event\listener;
use wcf\form\SearchForm;
use wcf\page\SearchResultPage;
use wcf\system\event\listener\IParameterizedEventListener;

/**
 * Handles the show results as threads option.
 * 
 * @author	Marcel Werk
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\Event\Listener
 */
class SearchListener implements IParameterizedEventListener {
	/**
	 * indicates if the only threads are searched
	 * @var	boolean
	 */
	public static $findThreads = false;
	
	/**
	 * @inheritDoc
	 */
	public function execute($eventObj, $className, $eventName, array &$parameters) {
		if ($eventName == 'readFormParameters') {
			/** @var SearchForm $eventObj */
			
			if (!empty($_POST['findThreads']) || !empty($_REQUEST['findUserThreads'])) {
				if (empty($eventObj->selectedObjectTypes) || in_array('com.woltlab.wbb.post', $eventObj->selectedObjectTypes)) {
					$eventObj->selectedObjectTypes = ['com.woltlab.wbb.post'];
				}
				
				if ($eventObj->sortField == 'relevance') {
					$eventObj->sortField = 'time';
				}
			}
		}
		
		if ($eventName == 'assignVariables') {
			/** @var SearchResultPage $eventObj */
			
			if (static::$findThreads) {
				$eventObj->resultListTemplateName = 'searchResultThreadList';
				$eventObj->resultListApplication = 'wbb';
			}
		}
	}
}
