<?php
namespace wbb\system\event\listener;
use wcf\system\event\listener\IParameterizedEventListener;
use wcf\system\form\builder\IFormDocument;
use wcf\system\package\plugin\ObjectTypePackageInstallationPlugin;

/**
 * Adds additional fields when adding and editing gallery-specific object types.
 * 
 * @author	Matthias Schmidt
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\Event\Listener
 * @since	3.2
 */
class ObjectTypePackageInstallationPluginAddFormFieldsListener implements IParameterizedEventListener {
	/**
	 * @inheritDoc
	 */
	public function execute(/* @var ObjectTypePackageInstallationPlugin $eventObj */$eventObj, $className, $eventName, array &$parameters) {
		/** @var IFormDocument $form */
		$form = $parameters['form'];
		
		// com.woltlab.wbb.box.threadList.condition
		$conditionContainer = $eventObj->getObjectTypeDefinitionDataContainer($form, 'com.woltlab.wbb.box.threadList.condition');
		$eventObj->addConditionFields(
			$conditionContainer,
			'com.woltlab.wbb.box.threadList.condition',
			false,
			false
		);
		
		// com.woltlab.wbb.bulkProcessing.thread.action
		$eventObj->addBulkProcessingActionFields($form, 'com.woltlab.wbb.bulkProcessing.thread.action');
		
		// com.woltlab.wbb.bulkProcessing.thread.condition
		$bulkProcessingConditionContainer = $eventObj->getObjectTypeDefinitionDataContainer($form, 'com.woltlab.wbb.bulkProcessing.thread.condition');
		$eventObj->addConditionFields(
			$bulkProcessingConditionContainer,
			'com.woltlab.wbb.bulkProcessing.thread.condition',
			false,
			false
		);
		
		// com.woltlab.wbb.bulkProcessing.post.action
		$eventObj->addBulkProcessingActionFields($form, 'com.woltlab.wbb.bulkProcessing.post.action');
		
		// com.woltlab.wbb.bulkProcessing.thread.condition
		$bulkProcessingConditionContainer = $eventObj->getObjectTypeDefinitionDataContainer($form, 'com.woltlab.wbb.bulkProcessing.post.condition');
		$eventObj->addConditionFields(
			$bulkProcessingConditionContainer,
			'com.woltlab.wbb.bulkProcessing.post.condition',
			false,
			false
		);
	}
}
