<?php
namespace wbb\system\event\listener;
use wbb\system\condition\thread\ThreadIntegerPropertyCondition;
use wbb\system\condition\thread\ThreadStateCondition;
use wbb\system\condition\thread\ThreadUnreadCondition;
use wcf\system\event\listener\IParameterizedEventListener;
use wcf\system\form\builder\container\IFormContainer;
use wcf\system\form\builder\field\BooleanFormField;
use wcf\system\form\builder\field\dependency\ValueFormFieldDependency;
use wcf\system\form\builder\field\TextFormField;
use wcf\system\package\plugin\ObjectTypePackageInstallationPlugin;

/**
 * Adds additional condition fields for the object type pip.
 * 
 * @author	Matthias Schmidt
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Gallery\System\Event\Listener
 * @since	3.2
 */
class ObjectTypePackageInstallationPluginAddConditionFieldsListener implements IParameterizedEventListener {
	/**
	 * @inheritDoc
	 */
	public function execute(/* @var ObjectTypePackageInstallationPlugin $eventObj */$eventObj, $className, $eventName, array &$parameters) {
		/** @var IFormContainer $dataContainer */
		$dataContainer = $parameters['dataContainer'];
		$prefix = $parameters['prefix'];
		$objectTypeDefinition = $parameters['objectTypeDefinition'];
		
		/** @var TextFormField $className */
		$className = $dataContainer->getDocument()->getNodeById('className');
		
		// `ThreadIntegerPropertyCondition`
		$dataContainer->appendChild(
			$eventObj->getIntegerConditionPropertyNameField(
				$className,
				ThreadIntegerPropertyCondition::class,
				$prefix . 'ThreadIntegerPropertyName',
				'wbb' . WCF_N . '_thread'
			)
		);
		$eventObj->definitionElementChildren[$objectTypeDefinition]['propertyname'] = '';
		
		// `ThreadUnreadCondition`
		$dataContainer->appendChild(
			$eventObj->getIntegerConditionPropertyNameField(
				$className,
				ThreadUnreadCondition::class,
				$prefix . 'ThreadUnreadPropertyName',
				'wbb' . WCF_N . '_thread',
				false
			)
		);
		$eventObj->definitionElementChildren[$objectTypeDefinition]['propertyName'] = '';
		
		// `ThreadStateCondition`
		$dataContainer->appendChild(
			BooleanFormField::create($prefix . 'AccessibleOnly')
				->objectProperty('accessibleOnly')
				->label('wbb.acp.pip.objectType.condition.threadState.accessibleOnly')
				->description('wbb.acp.pip.objectType.condition.threadState.accessibleOnly.description')
				->addDependency(
					ValueFormFieldDependency::create('className')
						->field($className)
						->values([ThreadStateCondition::class])
				)
		);
		$eventObj->definitionElementChildren[$objectTypeDefinition]['accessibleOnly'] = 0;
	}
}
