<?php
namespace wbb\system\event\listener;
use wcf\system\cronjob\PruneIpAddressesCronjob;
use wcf\system\event\listener\IParameterizedEventListener;

/**
 * Prunes the stored ip addresses.
 * 
 * @author      Alexander Ebert
 * @copyright	2001-2019 WoltLab GmbH
 * @license     WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package     WoltLabSuite\Forum\System\Event\Listener
 * @since       5.2
 */
class ForumPruneIpAddressesCronjobListener implements IParameterizedEventListener {
	/**
	 * @inheritDoc
	 */
	public function execute($eventObj, $className, $eventName, array &$parameters) {
		/** @var PruneIpAddressesCronjob $eventObj */
		$eventObj->columns['wbb'.WCF_N.'_post']['ipAddress'] = 'time';
	}
}
