<?php
namespace wbb\system\condition\thread;
use wbb\data\thread\Thread;
use wbb\page\IThreadPage;
use wcf\data\condition\Condition;
use wcf\system\condition\AbstractTimestampCondition;
use wcf\system\condition\IContentCondition;
use wcf\system\request\RequestHandler;

/**
 * Condition implementation for a timestamp property of a thread.
 * 
 * @author	Matthias Schmidt
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\Condition\Thread
 * @since	5.0
 */
class ThreadTimestampPropertyCondition extends AbstractTimestampCondition implements IContentCondition {
	/**
	 * @inheritDoc
	 */
	protected $className = Thread::class;
	
	/**
	 * @inheritDoc
	 */
	protected function getLanguageItemPrefix() {
		return 'wbb.thread.condition';
	}
	
	/** @noinspection PhpMissingParentCallCommonInspection */
	/**
	 * @inheritDoc
	 */
	protected function getPropertyName() {
		if (empty($this->propertyName)) {
			/** @noinspection PhpUndefinedFieldInspection */
			$propertyName = $this->getDecoratedObject()->propertyname;
			
			if ($propertyName) {
				$this->propertyName = $propertyName;
			}
			else {
				$objectTypePieces = explode('.', $this->getDecoratedObject()->objectType);
				$this->propertyName = end($objectTypePieces);
			}
		}
		
		return $this->propertyName;
	}
	
	/**
	 * @inheritDoc
	 */
	public function showContent(Condition $condition) {
		$requestObject = RequestHandler::getInstance()->getActiveRequest()->getRequestObject();
		if (!($requestObject instanceof IThreadPage)) return false;
		
		return $this->checkObject($requestObject->getThread(), $condition->conditionData);
	}
}
