<?php
namespace wbb\system\condition\thread;
use wbb\data\thread\ViewableThreadList;
use wcf\data\DatabaseObjectList;
use wcf\system\condition\AbstractSelectCondition;
use wcf\system\condition\IObjectListCondition;
use wcf\util\StringUtil;

/**
 * Condition implementation for handling the display mode of a list of threads.
 * 
 * Note that this condition does not work on its own as it only enables loading of the first post.
 * The code handling the thread list needs to manually determine the template used for displaying
 * the threads. Additionally, this condition relies on a ViewableThreadList object, not just a
 * ThreadList object.
 * 
 * @author	Matthias Schmidt
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\Condition\Thread
 * @since	5.0
 */
class ThreadDisplayModeCondition extends AbstractSelectCondition implements IObjectListCondition {
	/**
	 * @inheritDoc
	 */
	protected $description = 'wbb.thread.condition.displayMode.description';
	
	/**
	 * @inheritDoc
	 */
	protected $fieldName = 'wbbThreadDisplayMode';
	
	/**
	 * @inheritDoc
	 */
	protected $label = 'wbb.thread.condition.displayMode';
	
	/**
	 * @inheritDoc
	 */
	protected $fieldValue = 'table';
	
	/**
	 * @inheritDoc
	 */
	public function addObjectListCondition(DatabaseObjectList $objectList, array $conditionData) {
		if (!($objectList instanceof ViewableThreadList)) {
			throw new \InvalidArgumentException("Object list is no instance of '".ViewableThreadList::class."', instance of '".get_class($objectList)."' given.");
		}
		
		if ($conditionData[$this->fieldName] === 'firstPostExcerpt') {
			$objectList->firstPostLoading = true;
		}
	}
	
	/**
	 * @inheritDoc
	 */
	protected function getOptions() {
		return [
			'firstPostExcerpt' => 'wbb.thread.condition.displayMode.firstPostExcerpt',
			'table' => 'wbb.thread.condition.displayMode.table'
		];
	}
	
	/** @noinspection PhpMissingParentCallCommonInspection */
	/**
	 * @inheritDoc
	 */
	public function readFormParameters() {
		if (isset($_POST[$this->fieldName])) $this->fieldValue = StringUtil::trim($_POST[$this->fieldName]);
	}
}
