<?php
namespace wbb\system\condition\thread;
use wbb\data\thread\CacheBuilderThreadList;
use wbb\data\thread\ThreadList;
use wbb\page\IBoardPage;
use wcf\data\DatabaseObjectList;
use wcf\system\condition\AbstractCheckboxCondition;
use wcf\system\condition\IObjectListCondition;
use wcf\system\request\RequestHandler;

/**
 * Condition implementation for thread lists which applies a board filter if the current
 * page belongs to a board.
 * 
 * @author	Matthias Schmidt
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\Condition\Thread
 * @since	5.0
 */
class ThreadCurrentBoardCondition extends AbstractCheckboxCondition implements IObjectListCondition {
	/**
	 * @inheritDoc
	 */
	protected $description = 'wbb.thread.condition.currentBoard.description';
	
	/**
	 * @inheritDoc
	 */
	protected $fieldName = 'wbbThreadCurrentBoard';
	
	/**
	 * @inheritDoc
	 */
	protected $label = 'wbb.thread.condition.currentBoard';
	
	/**
	 * @inheritDoc
	 */
	public function addObjectListCondition(DatabaseObjectList $objectList, array $conditionData) {
		if (!($objectList instanceof ThreadList)) {
			throw new \InvalidArgumentException("Object list is no instance of '".ThreadList::class."', instance of '".get_class($objectList)."' given.");
		}
		
		$activeRequest = RequestHandler::getInstance()->getActiveRequest();
		if ($activeRequest !== null && $activeRequest->getRequestObject() instanceof IBoardPage) {
			$board = $activeRequest->getRequestObject()->getBoard();
			if ($board) {
				if ($objectList instanceof CacheBuilderThreadList) {
					$objectList->boardID = $board->boardID;
				}
				else {
					$objectList->getConditionBuilder()->add('thread.boardID = ?', [$board->boardID]);
				}
			}
		}
	}
}
