<?php
namespace wbb\system\condition\thread;
use wbb\data\thread\Thread;
use wbb\data\thread\ThreadList;
use wbb\page\IThreadPage;
use wbb\system\condition\AbstractObjectBoardCondition;
use wcf\data\condition\Condition;
use wcf\data\DatabaseObject;
use wcf\data\DatabaseObjectDecorator;
use wcf\data\DatabaseObjectList;
use wcf\system\condition\IContentCondition;
use wcf\system\request\RequestHandler;

/**
 * Condition implementation for the board a thread belongs to.
 * 
 * @author	Matthias Schmidt
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\Condition\Thread
 * @since	5.0
 */
class ThreadBoardCondition extends AbstractObjectBoardCondition implements IContentCondition {
	/**
	 * @inheritDoc
	 */
	protected $fieldName = 'wbbThreadBoardIDs';
	
	/**
	 * @inheritDoc
	 */
	protected $label = 'wbb.thread.condition.board';
	
	/**
	 * @inheritDoc
	 */
	public function addObjectListCondition(DatabaseObjectList $objectList, array $conditionData) {
		if (!($objectList instanceof ThreadList)) {
			throw new \InvalidArgumentException("Object list is no instance of '".ThreadList::class."', instance of '".get_class($objectList)."' given.");
		}
		
		if (!empty($conditionData[$this->fieldName . '_reverseLogic'])) {
			$objectList->getConditionBuilder()->add('thread.boardID NOT IN (?)', [$conditionData[$this->fieldName]]);
		}
		else {
			$objectList->getConditionBuilder()->add('thread.boardID IN (?)', [$conditionData[$this->fieldName]]);
		}
	}
	
	/**
	 * @inheritDoc
	 */
	public function checkObject(DatabaseObject $object, array $conditionData) {
		if (!($object instanceof Thread) && (!($object instanceof DatabaseObjectDecorator) || !($object->getDecoratedObject() instanceof Thread))) {
			throw new \InvalidArgumentException("Object is no (decorated) instance of '".Thread::class."', instance of '".get_class($object)."' given.");
		}
		
		$match = in_array($object->boardID, $conditionData[$this->fieldName]);
		
		if (!empty($conditionData[$this->fieldName . '_reverseLogic'])) {
			return !$match;
		}
		
		return $match;
	}
	
	/**
	 * @inheritDoc
	 */
	public function showContent(Condition $condition) {
		$requestObject = RequestHandler::getInstance()->getActiveRequest()->getRequestObject();
		if (!($requestObject instanceof IThreadPage)) return false;
		
		return $this->checkObject($requestObject->getThread(), $condition->conditionData);
	}
}
