<?php
namespace wbb\system\cache\runtime;
use wbb\data\post\Post;
use wbb\data\post\PostList;
use wcf\system\cache\runtime\AbstractRuntimeCache;

/**
 * Runtime cache implementation for posts.
 *
 * @author	Matthias Schmidt
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\Cache\Runtime
 * @since	5.0
 * 
 * @method	Post[]		getCachedObjects()
 * @method	Post		getObject($objectID)
 * @method	Post[]		getObjects(array $objectIDs)
 */
class PostRuntimeCache extends AbstractRuntimeCache {
	/**
	 * @inheritDoc
	 */
	protected $listClassName = PostList::class;
	
	public function cachePost(Post $post) {
		$this->objects[$post->postID] = $post;
	}
}
