<?php
namespace wbb\system\cache\builder;
use wbb\data\thread\form\option\ThreadFormOptionList;
use wcf\system\cache\builder\AbstractCacheBuilder;

/**
 * Caches all thread form options. 
 *
 * @author	Joshua Ruesweg
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\Cache\Builder
 */
class ThreadFormOptionCacheBuilder extends AbstractCacheBuilder {
	/**
	 * @inheritDoc
	 */
	protected function rebuild(array $parameters) {
		$data = [
			'threadFormOptions' => [],
			'threadFormOptionsByBoard' => [],
			'threadFormOptionsByForm' => []
		];
		
		$threadFormOptionList = new ThreadFormOptionList();
		$threadFormOptionList->readObjects();
		$data['threadFormOptions'] = $threadFormOptionList->getObjects();
		
		foreach ($threadFormOptionList->getObjects() as $object) {
			if ($object->isDisabled) continue;
			if (empty($object->formID)) continue;
			
			if (!isset($data['threadFormOptionsByForm'][$object->formID])) {
				$data['threadFormOptionsByForm'][$object->formID] = [];
			}
			
			$data['threadFormOptionsByForm'][$object->formID][] = $object;
		}
		
		return $data;
	}
}
