<?php
namespace wbb\system\cache\builder;
use wcf\system\cache\builder\AbstractCacheBuilder;
use wcf\system\database\util\PreparedStatementConditionBuilder;
use wcf\system\WCF;

/**
 * Caches the most active threads.
 * 
 * @author	Alexander Ebert
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\Cache\Builder
 */
class MostActiveThreadsCacheBuilder extends AbstractCacheBuilder {
	/**
	 * @inheritDoc
	 */
	protected $maxLifetime = 3600;
	
	/**
	 * @inheritDoc
	 */
	protected function rebuild(array $parameters) {
		$conditionBuilder = new PreparedStatementConditionBuilder();
		$conditionBuilder->add('isDisabled = ?', [0]);
		$conditionBuilder->add('isDeleted = ?', [0]);
		$conditionBuilder->add('movedThreadID IS NULL');
		if (!empty($parameters['boardID'])) {
			$conditionBuilder->add('boardID = ?', [$parameters['boardID']]);
		}
		if (!empty($parameters['timeFrame'])) {
			$conditionBuilder->add('time > ?', [TIME_NOW - $parameters['timeFrame'] * 86400]);
		}
		
		$sortOrder = 'DESC';
		if (!empty($parameters['sortOrder'])) {
			$sortOrder = $parameters['sortOrder'];
		}
		
		// get thread ids
		$sql = "SELECT		threadID, boardID
			FROM		wbb".WCF_N."_thread
			".$conditionBuilder."
			ORDER BY	replies {$sortOrder}, lastPostTime {$sortOrder}";
		$statement = WCF::getDB()->prepareStatement($sql, !empty($parameters['boardID']) ? $parameters['limit'] : $parameters['limit'] * 10);
		$statement->execute($conditionBuilder->getParameters());
		
		return $statement->fetchMap('threadID', 'boardID', true);
	}
}
