<?php
namespace wbb\system\cache\builder;
use wbb\data\board\BoardCache;
use wcf\system\cache\builder\AbstractCacheBuilder;
use wcf\system\database\util\PreparedStatementConditionBuilder;
use wcf\system\WCF;

/**
 * Caches the latest posts.
 * 
 * @author	Marcel Werk
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\Cache\Builder
 */
class LatestPostsCacheBuilder extends AbstractCacheBuilder {
	/**
	 * @inheritDoc
	 */
	protected $maxLifetime = 180;
	
	/**
	 * @inheritDoc
	 */
	protected function rebuild(array $parameters) {
		$conditionBuilder = new PreparedStatementConditionBuilder();
		$conditionBuilder->add('isDisabled = ?', [0]);
		$conditionBuilder->add('isDeleted = ?', [0]);
		$conditionBuilder->add('movedThreadID IS NULL');
		if (!empty($parameters['boardID'])) {
			$conditionBuilder->add('boardID = ?', [$parameters['boardID']]);
		}
		else {
			$boardIDs = [];
			foreach (BoardCache::getInstance()->getBoards() as $board) {
				if ($board->searchable) {
					$boardIDs[] = $board->boardID;
				}
			}
			
			if (empty($boardIDs)) return [];
			
			$conditionBuilder->add('boardID IN (?)', [$boardIDs]);
		}
		if (!empty($parameters['timeFrame'])) {
			$conditionBuilder->add('time > ?', [TIME_NOW - $parameters['timeFrame'] * 86400]);
		}
		
		$sortOrder = 'DESC';
		if (!empty($parameters['sortOrder'])) {
			$sortOrder = $parameters['sortOrder'];
		}
		
		$sql = "SELECT		thread.threadID, thread.boardID
			FROM		wbb".WCF_N."_thread thread
			".$conditionBuilder."
			ORDER BY	thread.lastPostTime {$sortOrder}, thread.threadID {$sortOrder}";
		$statement = WCF::getDB()->prepareStatement($sql, $parameters['limit'] * 10);
		$statement->execute($conditionBuilder->getParameters());
		
		return $statement->fetchMap('threadID', 'boardID', true);
	}
}
