<?php
namespace wbb\system\cache\builder;
use wbb\data\thread\HotThreadList;
use wcf\system\cache\builder\AbstractCacheBuilder;
use wcf\system\database\util\PreparedStatementConditionBuilder;
use wcf\system\WCF;

/**
 * Caches hot threads.
 * 
 * @author	Tim Duesterhus
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\Cache\Builder
 */
class HotThreadsCacheBuilder extends AbstractCacheBuilder {
	/**
	 * @inheritDoc
	 */
	protected $maxLifetime = 600;
	
	/**
	 * @inheritDoc
	 */
	protected function rebuild(array $parameters) {
		$conditionBuilder = new PreparedStatementConditionBuilder();
		$conditionBuilder->add('isDisabled = ?', [0]);
		$conditionBuilder->add('isDeleted = ?', [0]);
		$conditionBuilder->add('movedThreadID IS NULL');
		// Disallow threads in the future, otherwise we raise a negative number to a non integral power.
		// Don't use TIME_NOW in case the time of the database server differs.
		$conditionBuilder->add('time < UNIX_TIMESTAMP()');
		
		if (!empty($parameters['boardID'])) {
			$conditionBuilder->add('boardID = ?', [$parameters['boardID']]);
		}
		if (!empty($parameters['timeFrame'])) {
			$conditionBuilder->add('time > ?', [TIME_NOW - $parameters['timeFrame'] * 86400]);
		}
		
		$sortOrder = 'DESC';
		if (!empty($parameters['sortOrder'])) {
			$sortOrder = $parameters['sortOrder'];
		}
		
		// get thread ids
		$sql = "SELECT		thread.threadID, thread.boardID
			FROM		wbb".WCF_N."_thread thread
			".$conditionBuilder."
			ORDER BY	".HotThreadList::TEMPERATURE_FORMULA." {$sortOrder}, thread.time {$sortOrder}";
		$statement = WCF::getDB()->prepareStatement($sql, !empty($parameters['boardID']) ? $parameters['limit'] : $parameters['limit'] * 10);
		$statement->execute($conditionBuilder->getParameters());
		
		return $statement->fetchMap('threadID', 'boardID', true);
	}
}
