<?php
namespace wbb\system\cache\builder;
use wbb\data\board\Board;
use wcf\system\acl\ACLHandler;
use wcf\system\cache\builder\AbstractCacheBuilder;
use wcf\system\database\util\PreparedStatementConditionBuilder;
use wcf\system\WCF;

/**
 * Caches the board moderator permissions for a combination of user groups.
 * 
 * @author	Marcel Werk
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\Cache\Builder
 */
class BoardModeratorPermissionCacheBuilder extends AbstractCacheBuilder {
	/**
	 * @inheritDoc
	 */
	protected function rebuild(array $parameters) {
		$data = [];
		
		if (!empty($parameters)) {
			$conditionBuilder = new PreparedStatementConditionBuilder();
			$conditionBuilder->add('acl_option.objectTypeID = ?', [ACLHandler::getInstance()->getObjectTypeID('com.woltlab.wbb.board')]);
			$conditionBuilder->add('acl_option.categoryName LIKE ?', ['mod.%']);
			$conditionBuilder->add('option_to_group.optionID = acl_option.optionID');
			$conditionBuilder->add('option_to_group.groupID IN (?)', [$parameters]);
			$sql = "SELECT		option_to_group.groupID, option_to_group.objectID AS boardID, option_to_group.optionValue,
						acl_option.optionName AS permission
				FROM		wcf".WCF_N."_acl_option acl_option,
						wcf".WCF_N."_acl_option_to_group option_to_group
						".$conditionBuilder;
			$statement = WCF::getDB()->prepareStatement($sql);
			$statement->execute($conditionBuilder->getParameters());
			while ($row = $statement->fetchArray()) {
				if (!isset($data[$row['boardID']][$row['permission']])) $data[$row['boardID']][$row['permission']] = $row['optionValue'];
				else $data[$row['boardID']][$row['permission']] = $row['optionValue'] || $data[$row['boardID']][$row['permission']];
			}
			
			if (!empty($data)) {
				Board::inheritPermissions(null, $data);
			}
		}
		
		return $data;
	}
}
