<?php
namespace wbb\system\bulk\processing\thread;
use wbb\data\thread\ThreadAction;
use wbb\data\thread\ThreadList;
use wcf\data\DatabaseObjectList;

/**
 * Default bulk processing action implementation for threads.
 * 
 * @author	Matthias Schmidt
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\Bulk\Processing\Thread
 * @since	5.0
 */
class ThreadBulkProcessingAction extends AbstractThreadBulkProcessingAction {
	/**
	 * @inheritDoc
	 */
	public function executeAction(DatabaseObjectList $objectList) {
		if (!($objectList instanceof ThreadList)) {
			throw new \InvalidArgumentException("Object list is no instance of '".ThreadList::class."', instance of '".get_class($objectList)."' given.");
		}
		
		if (count($objectList)) {
			/** @noinspection PhpUndefinedFieldInspection */
			/** @noinspection PhpUndefinedFieldInspection */
			$threadAction = new ThreadAction($objectList->getObjects(), $this->object->action, [
				'isBulkProcessing' => true
			]);
			$threadAction->executeAction();
		}
	}
}
