<?php
namespace wbb\system\bulk\processing\post;
use wbb\data\post\PostAction;
use wbb\data\post\PostList;
use wcf\data\DatabaseObjectList;
use wcf\system\bulk\processing\TReasonedBulkProcessingAction;

/**
 * Bulk processing action implementation for trashing posts.
 * 
 * @author	Matthias Schmidt
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\Bulk\Processing\Post
 * @since	5.0
 */
class TrashPostBulkProcessingAction extends AbstractPostBulkProcessingAction {
	use TReasonedBulkProcessingAction;
	
	/**
	 * @inheritDoc
	 */
	public function executeAction(DatabaseObjectList $objectList) {
		if (!($objectList instanceof PostList)) {
			throw new \InvalidArgumentException("Object list is no instance of '".PostList::class."', instance of '".get_class($objectList)."' given.");
		}
		
		if (count($objectList)) {
			/** @noinspection PhpUndefinedFieldInspection */
			$postAction = new PostAction($objectList->getObjects(), $this->object->action, [
				'data' => [
					'reason' => $this->reason
				],
				'isBulkProcessing' => true
			]);
			$postAction->executeAction();
		}
	}
	
	/**
	 * @inheritDoc
	 */
	protected function getReasonFieldName() {
		return 'postTrashReason';
	}
}
