<?php
namespace wbb\system\box;
use wbb\data\board\BoardCache;
use wbb\data\board\BoardTagCloud;
use wbb\page\BoardPage;
use wcf\system\box\AbstractBoxController;
use wcf\system\language\LanguageFactory;
use wcf\system\request\RequestHandler;
use wcf\system\tagging\TypedTagCloud;
use wcf\system\WCF;

/**
 * Box for tag cloud within boards.
 *
 * @author	Marcel Werk
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\Box
 * @since	5.0
 */
class BoardTagCloudBoxController extends AbstractBoxController {
	/**
	 * @inheritDoc
	 */
	protected static $supportedPositions = ['footerBoxes', 'sidebarLeft', 'sidebarRight'];
	
	/**
	 * @inheritDoc
	 */
	protected function loadContent() {
		if (MODULE_TAGGING && WBB_THREAD_ENABLE_TAGS && WCF::getSession()->getPermission('user.tag.canViewTag')) {
			$languageIDs = [];
			if (LanguageFactory::getInstance()->multilingualismEnabled()) {
				$languageIDs = WCF::getUser()->getLanguageIDs();
			}
			
			if (RequestHandler::getInstance()->getActiveRequest() !== null && RequestHandler::getInstance()->getActiveRequest()->getRequestObject() instanceof BoardPage) {
				$requestObject = RequestHandler::getInstance()->getActiveRequest()->getRequestObject();
				
				// hide for private boards, unless the user can view private threads too
				$board = BoardCache::getInstance()->getBoard($requestObject->boardID);
				if (!$board->isPrivate || $board->canReadPrivateThreads()) {
					$tagCloud = new BoardTagCloud($requestObject->boardID, $languageIDs);
					$tags = $tagCloud->getTags();
					if (!empty($tags)) {
						$this->content = WCF::getTPL()->fetch('boardTagCloudBox', 'wbb', [
							'board' => $requestObject->board,
							'tagLinkParameters' => $requestObject->tagLinkParameters,
							'tags' => $tags
						], true);
					}
				}
			}
			else {
				$tagCloud = new TypedTagCloud('com.woltlab.wbb.thread', $languageIDs);
				$tags = $tagCloud->getTags();
				if (!empty($tags)) {
					$this->content = WCF::getTPL()->fetch('tagCloudBox', 'wcf', [
						'tags' => $tags,
						'taggableObjectType' => 'com.woltlab.wbb.thread'
					], true);
				}
			}
		}
	}
}
