<?php
namespace wbb\system;
use wbb\data\board\Board;
use wbb\data\thread\Thread;
use wbb\page\BoardListPage;
use wcf\system\application\AbstractApplication;
use wcf\system\page\PageLocationManager;

/**
 * This class extends the main WCF class by forum specific functions.
 * 
 * @author	Alexander Ebert
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System
 */
class WBBCore extends AbstractApplication {
	/**
	 * @inheritDoc
	 */
	protected $primaryController = BoardListPage::class;
	
	/**
	 * Sets location data.
	 * 
	 * @param       Board[]         $parentBoards
	 * @param       Board|null      $board
	 * @param       Thread|null     $thread
	 * @since       5.0
	 */
	public function setLocation(array $parentBoards = [], Board $board = null, Thread $thread = null) {
		// add thread
		if ($thread !== null) {
			PageLocationManager::getInstance()->addParentLocation('com.woltlab.wbb.Thread', $thread->threadID, $thread);
		}
		
		// add board
		if ($board !== null) {
			PageLocationManager::getInstance()->addParentLocation('com.woltlab.wbb.Board', $board->boardID, $board, true);
		}
		
		// add parent boards
		$parentBoards = array_reverse($parentBoards);
		foreach ($parentBoards as $parentBoard) {
			PageLocationManager::getInstance()->addParentLocation('com.woltlab.wbb.Board', $parentBoard->boardID, $parentBoard);
		}
	}
}
