<?php
namespace wbb\page;
use wbb\data\thread\WatchedThreadList;
use wbb\system\WBBCore;
use wcf\page\SortablePage;
use wcf\system\WCF;

/**
 * Shows the list of watched threads.
 * 
 * @author	Marcel Werk
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\Page
 * 
 * @property	WatchedThreadList	$objectList
 */
class WatchedThreadListPage extends SortablePage {
	/**
	 * @inheritDoc
	 */
	public $defaultSortField = WBB_BOARD_DEFAULT_SORT_FIELD;
	
	/**
	 * @inheritDoc
	 */
	public $defaultSortOrder = WBB_BOARD_DEFAULT_SORT_ORDER;
	
	/**
	 * @inheritDoc
	 */
	public $itemsPerPage = WBB_BOARD_THREADS_PER_PAGE;
	
	/**
	 * @inheritDoc
	 */
	public $loginRequired = true;
	
	/**
	 * @inheritDoc
	 */
	public $objectListClassName = WatchedThreadList::class;
	
	/**
	 * @inheritDoc
	 */
	public $validSortFields = ['topic', 'username', 'time', 'views', 'replies', 'lastPostTime', 'cumulativeLikes'];
	
	/**
	 * @inheritDoc
	 */
	public function readParameters() {
		parent::readParameters();
		
		/** @noinspection PhpUndefinedFieldInspection */
		if (WCF::getUser()->threadsPerPage) {
			/** @noinspection PhpUndefinedFieldInspection */
			$this->itemsPerPage = WCF::getUser()->threadsPerPage;
		}
	}
	
	/**
	 * @inheritDoc
	 */
	public function readData() {
		parent::readData();
		
		// add breadcrumbs
		WBBCore::getInstance()->setLocation();
	}
	
	/**
	 * @inheritDoc
	 */
	public function assignVariables() {
		parent::assignVariables();
		
		WCF::getTPL()->assign([
			'validSortFields' => $this->validSortFields
		]);
	}
}
